% createEHFunctions    Create convex sum function handles.
%   This is a convenient way to generate the functions required for
%   unconstrained optimization algorithms on the Stiefel manifold via the 
%   Euler-Hurwitz parameterization.
%   [F G] = createEHFunctions(RHO, m, n, PURE, GRAD_PURE) creates two
%   one-parameter function handles F(X) and G(X). F(X), for a real vector X of
%   length dimSt(m, n), calculates the convex sum
%
%   F(U(X)) = \sum_i p_i PURE(\psi_i),
% 
%   where {p_i, \psi_i} is the decomposition of the density matrix RHO
%   parameterized by the m x n Stiefel matrix U, which is in turn 
%   parameterized by the input vector X. G(X) is the gradient of F(X).
%   PURE is a pure-state entanglement measure, and GRAD_PURE is the gradient 
%   w.r.t. to its real and imaginary parts. Both functions, PURE and 
%   GRAD_PURE, must take a state vector as their only argument.
% 
%   See also: createConvexFunctions, buildUnitary, buildUnitary_der

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function [f g] = createEHFunctions(rho, m, n, PURE, GRAD_PURE)

[f_cs, g_cs] = createConvexFunctions(rho, PURE, GRAD_PURE);

f = @(x) f_cs(buildUnitary(x, m, n));
g = @(x) grad_eh_adapt(x, m, n, g_cs);
