% createConvexFunctions    Create convex sum function handles.
%   This is a convenient way to generate the functions required for direct
%   optimization algorithms on the Stiefel manifold.
%   [F G] = createConvexFunctions(RHO, PURE, GRAD_PURE) creates two
%   one-parameter function handles F(U) and G(U). F(U), for a Stiefel matrix
%   U, calculates the convex sum
%
%   F(U) = \sum_i p_i PURE(\psi_i),
% 
%   where {p_i, \psi_i} is the decomposition of the density matrix RHO
%   parameterized by U. G(U) is the gradient of F(U). PURE is a 
%   pure-state entanglement measure, and GRAD_PURE is the gradient w.r.t. 
%   to its real and imaginary parts. Both functions, PURE and GRAD_PURE, 
%   must take a state vector as their only argument.
%
%   See also: createEHFunctions, convexSum, grad_convexSum

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function [f g] = createConvexFunctions(rho, PURE, GRAD_PURE)

[V D] = densityEig(rho);

f = @(x) convexSum(x, PURE, V, D);
g = @(x) grad_convexSum(x, PURE, GRAD_PURE, V, D);