% completeGramSchmidt     Complete a Stiefel matrix to an unitary matrix.
% Z = completeGramSchmidt(X) takes the full rank m x n Stiefel matrix X
% and completes it to a m x m unitary matrix Z such that the first n columns of
% Z coincide with all columns of X.
function Z = completeGramSchmidt(X)

[m, n] = size(X);

if (rank(X) ~= n)
    
    error('Input matrix needs to have full rank.');
end

Z = zeros(m, m);

% Fill first n columns of W with X.
Z(:, 1:n) = X;

% Fill the final (m-n) columns with linearly independent unit vectors
% (assuming that these vectors are also linearly independent from the
% columns in X.
Z(:, (n+1):m) = eye(m, m-n);

% Perform a Gram-Schmidt orthogonalization.
for i = 1:m

    wtmp = Z(:, i);
    
    for k = 1:(i-1)

        wtmp = wtmp - trace(Z(:, i)*Z(:, k)')*Z(:, k);
    end
    
    Z(:, i) = wtmp/norm(wtmp);
end
