function [tolf tolx tolg maxiter] = get_termination_criteria(varargin)

    % DEFAULT VALUES
    
    tolf = 1e-12;
    tolx = 1e-10;
    tolg = 1e-10;
    maxiter = 1000;
    
    if (nargin == 1)
    
        opts = varargin{1};
        
        if (~isstruct(opts))
            
            error('Options must be provided as a struct.');
        end            
        
        if (isfield(opts, 'TolFun'))
            
            tolf = opts.TolFun;
        end
        
        if (isfield(opts, 'TolX'))
            
            tolx = opts.TolX;
        end
        
        if (isfield(opts, 'TolG'))
            
            tolg = opts.TolG;
        end
        
        if (isfield(opts, 'MaxIter'))
            
            maxiter = opts.MaxIter;
        end
    end
    
    if (~isscalar(tolf) || ~isfloat(tolf) || tolf <= 0)
        
        error('Option TolFun must be a single positive number.');
    end
    
    if (~isscalar(tolx) || ~isfloat(tolx) || tolx <= 0)
        
        error('Option TolX must be a single positive number.');
    end

    if (~isscalar(tolg) || ~isfloat(tolg) || tolg <= 0)
        
        error('Option TolG must be a single positive number.');
    end

    if (~isscalar(maxiter) || ~isfloat(maxiter) || maxiter <= 0)
        
        error('Option MaxIter must be a single positive integer.');
    end
end