%tangle   Three-tangle of a pure state of three qubits.
%   t = tangle(psi) calculates the three-tangle of the state psi.
%
%   See also: grad_tangle

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function t = tangle(psi)

if (sum(sort(size(psi)) ~= [1, 8]) > 0)
    
    error('Input vector must be of length 8.');
end


a000 = psi(1);
a001 = psi(2);
a010 = psi(3);
a011 = psi(4);
a100 = psi(5);
a101 = psi(6);
a110 = psi(7);
a111 = psi(8);

d1 = a000^2 * a111^2 + a001^2 * a110^2 + ...
     a010^2 * a101^2 + a100^2 * a011^2;

d2 = a000 * a111 * a011 * a100 + a000 * a111 * a101 * a010 + ...
     a000 * a111 * a110 * a001 + a011 * a100 * a101 * a010 + ...
     a011 * a100 * a110 * a001 + a101 * a010 * a110 * a001;

d3 = a000 * a110 * a101 * a011 + a111 * a001 * a010 * a100;

t = 4*abs(d1 - 2*d2 + 4*d3);

if (t < eps) 
    
    t = 0; 
end
