%grad_tangle   Gradient of three-tangle.
%   g = grad_tangle(psi) returns the gradient (element-wise derivatives w.r.t. 
%   to real and imaginary parts of psi) of the three-tangle, evaluated at
%   psi.
%
%   See also: tangle

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = grad_tangle(psi)

a1 = psi(1);
a2 = psi(2);
a3 = psi(3);
a4 = psi(4);
a5 = psi(5);
a6 = psi(6);
a7 = psi(7);
a8 = psi(8);

g1 = zeros(8, 1);
g2 = zeros(8, 1);
g3 = zeros(8, 1);

g1(1) = 2*a1 * a8^2;
g1(2) = 2*a2 * a7^2;
g1(3) = 2*a3 * a6^2;
g1(4) = a5^2 * 2*a4;
g1(5) = 2*a5 * a4^2;
g1(6) = a3^2 * 2*a6;
g1(7) = a2^2 * 2*a7;
g1(8) = a1^2 * 2*a8;

g2(1) = a8 * a4 * a5 + a8 * a6 * a3 + a8 * a7 * a2;
g2(2) = a1 * a8 * a7 + a4 * a5 * a7 + a6 * a3 * a7;
g2(3) = a1 * a8 * a6 + a4 * a5 * a6 + a6 * a7 * a2;
g2(4) = a1 * a8 * a5 + a5 * a6 * a3 + a5 * a7 * a2;
g2(5) = a1 * a8 * a4 + a4 * a6 * a3 + a4 * a7 * a2;
g2(6) = a1 * a8 * a3 + a4 * a5 * a3 + a3 * a7 * a2;
g2(7) = a1 * a8 * a2 + a4 * a5 * a2 + a6 * a3 * a2;
g2(8) = a1 * a4 * a5 + a1 * a6 * a3 + a1 * a7 * a2;

g3(1) = a7 * a6 * a4;
g3(2) = a8 * a3 * a5;
g3(3) = a8 * a2 * a5;
g3(4) = a1 * a7 * a6;
g3(5) = a8 * a2 * a3;
g3(6) = a1 * a7 * a4;
g3(7) = a1 * a6 * a4;
g3(8) = a2 * a3 * a5;

d1 = a1^2 * a8^2 + a2^2 * a7^2 + a3^2 * a6^2 + a5^2 * a4^2;
d2 = a1 * a8 * a4 * a5 + a1 * a8 * a6 * a3 + a1 * a8 * a7 * a2 + a4 * a5 * a6 * a3 + a4 * a5 * a7 * a2 + a6 * a3 * a7 * a2;
d3 = a1 * a7 * a6 * a4 + a8 * a2 * a3 * a5;

g = g1 - 2*g2 + 4*g3;
d = d1 - 2*d2 + 4*d3;

t = g*conj(d);

res = 4*(real(t) + sqrt(-1)*real(sqrt(-1)*t))/abs(d);
