%grad_entropyOfEntanglement   Gradient of entropy of entanglement.
%   g = grad_entropyOfEntanglement(psi, dims) returns the gradient
%   (element-wise derivatives w.r.t. to real and imaginary parts of psi) of
%   the entropy of entanglement, evaluated at psi. dims = [d1, d2] specifies 
%   subsystem dimensions. Note that psi must be of length d1*d2.
%
%   See also: entropyOfEntanglement

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = grad_entropyOfEntanglement(psi, dims)

rhoB = pTrace(psi*psi', 2, dims);
dS = (-logm(rhoB + 10*eps*eye(size(rhoB))).' - eye(size(rhoB)))/log(2);

d1 = dims(1);
d2 = dims(2);

res = zeros(size(psi));

for k1 = 0:(d1 - 1)
   for k2 = 1:d2
       
       res(k1*d2 + k2) = 2*dS(:, k1 + 1).'*psi(k2:d2:length(psi));
   end
end
