%convexSum    Convex sum parameterized by the complex Stiefel matrix U.
%   s = convexSum(U, PURE, CHI, LAMBDA) calculates the convex sum 
%
%   s = \sum_i p_i*PURE(psi_i),
%
%   where the pure-state decomposition [p, psi] of a density matrix specified
%   by [CHI, LAMBDA] is parameterized by the complex Stiefel matrix U. U must be
%   of size k x r, where r is the length of LAMBDA, and k >= r. LAMBDA is 
%   a column vector holding the positive eigenvalues of the density matrix
%   and the columns of CHI are the corresponding eigenvectors. PURE is a
%   pure-state entanglement measure taking a state vector as its only input.
%
%   See also: grad_convexSum, densityEig

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = convexSum(U, PURE, CHI, LAMBDA)

[psi p] = psDecomposition(U(:, 1:length(LAMBDA)), CHI, LAMBDA);

m = zeros(1, length(p));

for i = 1:length(p)
   
    m(i) = PURE(psi(:, i));
end

res = real(m*p);
