%randUnitaryMatrix   Random unitary matrix.
%   U = randUnitaryMatrix(m) returns a random m x m unitary matrix. U is 
%   drawn from the Haar measure of the unitary group.
%
%   U = randUnitaryMatrix(m, n) returns a random m x n matrix from the
%   Stiefel manifold (column-orthonormal complex m x n matrices). The distribution
%   of the random variable U is also induced by the Haar measure of the 
%   unitary group.
%
%   See [F. Mezzadri, Notices of the AMS 54, 592 (2007);
%   arXiv:math-ph/0609050] for more details.

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function U = randUnitaryMatrix(m, varargin)

n = m;

if (nargin > 1)
    
    n = min(m, varargin{1});
end

[Q R] = qr((randn(m, n) + sqrt(-1)*randn(m, n))/sqrt(2), 0);
L = diag(diag(R)./abs(diag(R)));
U = Q*L;
