% randDensityMatrix    Random density matrix.
%    RHO = randDensityMatrix(n) returns a random full-rank n x n density
%    matrix drawn according to the Hilbert-Schmidt measure.
%
%    RHO = randDensityMatrix(n, 'bures') draws from the Bures measure.
%
%    See [V. Al. Osipov, H.-J. Sommers, and K. Zyczkowski, J. Phys. A 43, 
%    055302 (2010)] for more details.

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function rho = randDensityMatrix(n, varargin)

bures = 0;

if (nargin > 1)

    if (lower(varargin{1}) == 'bures')
        
        bures = 1;
    else

        error(['Unknown argument: ', varargin{1}]);
    end
end

A = randn(n, n) + 1i*randn(n, n);

if (bures)
    
    IU = eye(n) + randUnitaryMatrix(n, n);
    
    rho = IU*A*A'*IU';
    rho = rho/trace(rho);
else

    rho = A*A';
    rho = rho/trace(rho);
end