%pTrace_script     Script implementation of pTrace.c, pTrace.cc.
%   This file is only given for convenience, since it is easier to read
%   than the C and C++ files. Compile and use pTrace.c (Matlab) or 
%   pTrace.cc (Octave) for better performance.
%
%   See also: pTrace

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>

function r = pTrace_script(rho, system, dimensions)

    if length(system) == 1
    
        n = length(dimensions);
        m = prod(dimensions)/dimensions(system);

        dimred = dimensions([1:(system - 1), (system + 1):n]);
        nr     = n - 1;

        r = zeros(m, m);

        for i = 1:m

            inds1 = getIndices(i, dimred);

            for k = 1:m

                inds2 = getIndices(k, dimred);

                tmp = 0;

                for s = 1:dimensions(system)

                    tmp = tmp + rho(getIndex([inds1(1:(system - 1)), s, inds1(system:nr)], dimensions), ...
                                    getIndex([inds2(1:(system - 1)), s, inds2(system:nr)], dimensions));
                end

                r(i, k) = tmp;
            end
        end

    else

        for i = length(system):-1:1
        
            rho = gtr(rho, system(i), dimensions);
            dimensions = dimensions([1:(system(i) - 1), (system(i) + 1):length(dimensions)]);
        end

        r = rho;
    end
end




function inds = getIndices(index, dimensions)

    n  = length(dimensions);
    ix = index;

    inds = zeros(1, n);

    for i = 2:n
    
        pr  = prod(dimensions(i:n));
        tmp = floor((ix - 1)/pr);
    
        inds(i-1) = tmp + 1;
        ix = ix - tmp*pr;
    end

    inds(n) = ix;
end



function ind = getIndex(indices, dimensions)

    ind = 0;
    pr  = 1;

    for i = length(indices):-1:1
    
        ind = ind + (indices(i) - 1)*pr;
        pr  = pr*dimensions(i);
    end

    ind = ind + 1;
end





    
