%pTrace    Arbitrary partial trace over arbitrary subsystems.
%   P = pTrace(RHO, sys, dims) returns the partial trace of the 
%   density matrix RHO over the subsystems sys. dims is a vector containing
%   all subsystem dimensions, and sys is a vector listing the subsystem
%   indices (counting from 1) to be traced out.
%
%   Example: Assume RHO is a density matrix acting on a 2 x 3 x 4 x 5 dimensional
%   Hilbert space. Then
%
%   P = pTrace(RHO, [2,3], [2,3,4,5]);
%
%   yields the 2 x 5 dimensional reduced density matrix obtained by tracing
%   out the 2nd and 3rd subsystems of dimensions 3 and 4, respectively.
%
%   See also: pTrace_script

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>
