% grad_eh_adapt    Adapter function to calculate the gradient of a convex 
%                  sum parameterized by Stiefel matrix angles.
% G = grad_eh_adapt(X, m, n, GRAD_U) calculates the gradient (w.r.t. X)
% of a convex sum S(U(X)) at a specific pure-state decomposition specified 
% by the angles X, which in turn parameterize the Stiefel matrix U(X). 
% GRAD_U must return (in its real and imaginary part) the derivatives of 
% S(U) with respect to Re(U_ij), Im(U_ij).
%
% See also: grad_convexSum

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function g = grad_eh_adapt(X, m, n, GRAD)

dF = GRAD(buildUnitary(X, m, n));

g = zeros(size(X));

for i = 1:length(X)
    
    dU = grad_buildUnitary(X, m, n, i);
    g(i) = sum(sum(real(dF).*real(dU) + imag(dF).*imag(dU)));
end
