%densityEig    Get eigendecomposition of a density matrix in a convenient form.
%   [V D] = densityEig(RHO) returns a vector D with the rank(RHO) positive
%   eigenvalues of RHO in decreasing order. The columns of V contain the 
%   corresponding normalized eigenvectors.

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function [V D] = densityEig(rho)

% Get eigendecomposition
[V D] = eig(rho);

% Get rid of numerical errors in the imaginary part
D = real(diag(D));

% Only prepare eigenstates with corresponding eigenvectors larger than eps.
ind = find(abs(D) > eps);
D = real(D(ind));
V = V(:, ind);

% Sort in decreasing order
[D perm] = sort(D, 'descend');
V = V(:, perm);