%buildUnitary_script     Script implementation of buildUnitary.c, buildUnitary.cc.
%   This file is only given for convenience, since it is easier to read
%   than the C and C++ files. Compile and use buildUnitary.c (Matlab) or 
%   buildUnitary.cc (Octave) for better performance.
%
%   See also: buildUnitary  

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>

function U = buildUnitary_script(X, m, n)

pt = 0;
pp = m*n - n/2*(n + 1);
pc = 2*pp;

U = zeros(m, n);

% first set up the phases on the diagonal
U(1:n, 1:n) = diag(exp(1i*X(pc + (1:n))));

tX  = exp(1i*X(pt + (1: pp)));
pX  = exp(1i*X(pp + (1: pp)));
pXc = exp(-1i*X(pp + (1: pp)));

ctX = real(tX);
stX = imag(tX);

cnt = 1;

for i = n:-1:1
    for k = i:(m-1)

        row_tmp = U(k, i:n);
        
        U(k,   i:n) = ctX(cnt)*pXc(cnt)*row_tmp - stX(cnt)*pXc(cnt)*U(k+1, i:n);
        U(k+1, i:n) = stX(cnt)*pX(cnt) *row_tmp + ctX(cnt)*pX(cnt)*U(k+1, i:n);

        cnt = cnt + 1;
    end
end