%meyer_wallach   Meyer-Wallach entanglement measure of a pure state.
%   mw = meyer_wallach(psi) calculates the Meyer-Wallach entanglement
%   measure of the pure state psi of an arbitrary number of qubits.
%
%   See also: grad_meyer_wallach

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = meyer_wallach(psi)

n = log2(length(psi));

if (n - floor(n) ~= 0)
    
    error('Dimension of psi must be a power of 2.');
end

dims = 2*ones(1, n);

rho = psi*psi';

res = 0;

for i = 1:n
    
    list = [1:(i-1), (i+1):n];
    
    res = res + trace(pTrace(rho, list, dims)^2);
end

res = 2*(1 - res/n);