%grad_meyer_wallach   Gradient of Meyer-Wallach entanglement measure.
%   g = grad_meyer_wallach(psi) returns the gradient (element-wise derivatives w.r.t. 
%   to real and imaginary parts of psi) of the Meyer-Wallach measure, evaluated at
%   psi.
%
%   See also: meyer_wallach

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = grad_meyer_wallach(psi)

N = log2(length(psi));
d = 2;

rho = psi*psi';
dims = d*ones(1, N);
res = zeros(length(psi), 1);

for k = 1:N

    list = [1:(k-1), (k+1):N];
    rho_k = pTrace(rho, list, dims);

    for i = 1:length(psi)
    
        % write i - 1 in subsystem basis
        si = zeros(1, N);
        ti = i - 1;
        for ex = (N-1):-1:0
            si(N - ex) = floor(ti/d^ex);
            ti = ti - si(N - ex)*d^ex;
        end

        for j = 1:d
            stmp = si;
            stmp(k) = j - 1;
            ind = sum(stmp.*d.^((N-1):-1:0)) + 1;

            res(i) = res(i) + psi(ind)*rho_k(si(k)+1, j);
        end
    end
end

res = -8/N*res;