%eof2x2   Entanglement of formation of two qubits.
%   e = eof2x2(rho) calculates the exact entanglement of formation of the 
%   bipartite mixed state rho (4 x 4 matrix) according to the analytical
%   expression in [W. K. Wootters, Phys. Rev. Lett. 80, 2245 (1998)].

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/

function res = eof2x2(rho)

% Calculate concurrence
A = [0, 0, 0,-1; 0, 0, 1, 0; 0, 1, 0, 0; -1, 0, 0, 0];
tmp = sqrt(sort(real(eig(rho*A*conj(rho)*A))));
c = max(0,tmp(4) - sum(tmp(1:3)));


t = (1 + sqrt(1 - c^2))/2;

if t == 0
    
    res = 1;
elseif t == 1
    
    res = 0;
else
    
    res = -t*log2(t) - (1 - t)*log2(1 - t);
end
