%entropyOfEntanglement   Von Neumann entropy of a reduced bipartite state.
%   e = entropyOfEntanglement(psi, dims) returns the von Neumann entropy of
%   the state obtained after tracing out the second subsystem of the vector
%   psi. dims = [d1, d2] specifies the dimensions of the two subsystems.
%   Note that psi must be of length d1*d2.
%
%   See also: grad_entropyOfEntanglement

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>

function res = entropyOfEntanglement(psi, dims)

rhoB = pTrace(psi*psi', 2, dims);
eigB = eig(rhoB);

res = -eigB'*log2(max(eigB, 1e-15));
