%tangleGHZW    Analytical formula for tangle of GHZ/W mixture.
%   t = tangleGHZW(p) returns the tangle of the state
%
%   \rho = p*|GHZ><GHZ| + (1 - p)*|W><W|.
%
%   See [R. Lohmayer et al., Phys. Rev. Lett. 97, 260502 (2006)].

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>

function res = tangleGHZW(p)

p0 = 4*2^(1/3)/(3 + 4*2^(1/3));
p1 = 1/2 + 3*sqrt(465)/310;

if (p < p0)
    
    res = 0;
    
elseif (p < p1)
    
    res = p^2 - 8*sqrt(6)/9 * sqrt(p*(1-p)^3);

else
    
    res = 1 - (1 - p)*(3/2 + sqrt(465)/18);
end