%

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/


% Define GHZ and W state
GHZ = [1; 0; 0; 0; 0; 0; 0; 1]/sqrt(2);
W   = [0; 1; 1; 0; 1; 0; 0; 0]/sqrt(3);

% Choose a specific value for the mixing-parameter p
p = 0.7;

% Define the density matrix of the mixture
rho = p*GHZ*GHZ' + (1 - p)*W*W';

% Choose cardinality
r = rank(rho);
k = r + 4;

% Create function handles to be used in the optimization
[f_eh, g_eh] = createEHFunctions(rho, k, r, @tangle, @grad_tangle);

% Choose a random starting point, originally defined as
% X0 = 2*pi*randn(1, dimSt(k, r));
X0 = load('example_tangleGHZW_X0.dat');

% Perform the optimization
[t_res, X_res, info] = bfgs_min(f_eh, g_eh, X0);

% Compare function values during the iteration with the analytical result
% (using tangleGHZW) to demonstrate convergence
semilogy(abs(info.fvals - tangleGHZW(0.7)));
