%

% Copyright (C) 2011 Beat Röthlisberger
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>


% Choose the dimension of each qudit
d = 5;

% Create the maximally entangled state in that space
psi = 0;

for i = 1:d
    
    tmp = zeros(d, 1);
    tmp(i) = 1;
    psi = psi + kron(tmp, tmp);
end

psi = psi/sqrt(d);

% Choose a specific value for the mixing-parameter f
f = 0.3;

% Define the density matrix of the mixture
rho = (1 - f)/(d^2 - 1)*(eye(d^2) - (psi*psi')) + f*(psi*psi');

% Get eigendecomposition of the density matrix
[chi lambda] = densityEig(rho);

% In order for Matlab and Octave to return the same results, we have to
% import chi from a file at this point. The two different platforms use
% different diagonalization routines, yielding different eigenvectors for
% the 8-fold degenerate subspace of rho.
chi = load('example_eofIsotropic_chi.txt');

% Choose cardinality
r = rank(rho);
k = 2*r;

% Create function handles of the entropy of entanglement and its gradient
eoe = @(x) entropyOfEntanglement(x, [d, d]);
grad_eoe = @(x) grad_entropyOfEntanglement(x, [d, d]);

% Create function handles of the objective function and its gradient 
f_cr = @(x) convexSum(x, eoe, chi, lambda);
g_cr = @(x) grad_convexSum(x, eoe, grad_eoe, chi, lambda);

% Choose a random starting point, originally defined as
% U0 = randUnitaryMatrix(k, k);
U0r = load('example_eofIsotropic_U0r.txt');
U0i = load('example_eofIsotropic_U0i.txt');
U0 = U0r + 1i*U0i;

% Perform the optimization
[e_res, U_res, info] = cg_min(f_cr, g_cr, U0);

% Compare function values during the iteration with the analytical result
% (using eofIsotropic) to demonstrate convergence
semilogy(abs(info.fvals - eofIsotropic(f, d)));
